import { tassign } from 'tassign';
import {
  NEW_CONCEPT_HISTORY,
  PREVIOUS_CONCEPT_HISTORY,
  CONCEPT_CARD_POPULATING,
  CONCEPT_CARD_MVP_DELETING,
  CONCEPT_CARD_MVP_DELETED,
  CONCEPT_CARD_POPULATED,
  DISPLAY_CONCEPT_CARD,
  CLOSE_CONCEPT_CARD,
  CLEAR_CONCEPT_CARD_STATE,
  DISABLE_CONCEPT_CARD_VIEW,
  ENABLE_CONCEPT_CARD_VIEW,
  UPDATE_CONCEPT_CARD_TAB_SELECTION,
  SET_CARD_DATA,
  SET_ADDING_DEFINITION_MVP_STATE,
  RESET_ADD_MVP_STATE,
  SET_ADDING_ALT_DEFINITION_MVP_STATE,
  SET_ADDING_SYNONYM_MVP_STATE,
  CONCEPT_CARD_MVP_ADDING,
  CONCEPT_CARD_MVP_ADDED,
  DISPLAY_CONCEPT_CARD_DETAIL,
  SET_ADDING_SUPER_CLASS_MVP_STATE,
  SET_ADDING_SUB_CLASS_MVP_STATE,
  SET_ADDING_INTER_ONTOLOGY_MVP_STATE,
  SET_ADDING_PROPERTY_MVP_STATE,
  SET_ADDING_RELATIONSHIP_MVP_STATE,
  SET_ADDING_MAPPING_DATA_ELEMENT_MVP_STATE,
  SET_ADDING_MAPPING_VALIDATION_MVP_STATE,
  SET_ADDING_MAPPING_ALGORITHM_MVP_STATE,
  UPDATE_CONCEPT_CARD_TAB_FOCUS,
  BUILD_TAB_DATA,
  UPDATE_CONCEPT_CARD_BOOKMARK_MESSAGE,
} from '../actions';

function previousConceptHistory(state, action) {
  const newArray =  state.conceptHistory.concat();
  newArray.splice(-1,1);
  return tassign(state, {
    conceptHistory: newArray
  });
}

function newConceptHistory(state, action) {
  const newArray = state.conceptHistory.concat();
  newArray.push(action.payload);
  return tassign(state, {
    conceptHistory: newArray
  });
}

function conceptCardPopulating(state, action) {
  return tassign(state, {cardPopulating: true, cardPopulated: false});
}

function conceptCardMvpDeleting(state, action) {
  return tassign(state, {mvpRemoving: true})
}

function conceptCardMvpDeleted(state, action) {
  return tassign(state, {mvpRemoving: false})
}

function conceptCardMvpAdding(state, action) {
  return tassign(state, {mvpAdding: true})
}

function conceptCardMvpAdded(state, action) {
  return tassign(state, {mvpAdding: false})
}

function conceptCardPopulated(state, action) {
  return tassign(state, {cardPopulating: false, cardPopulated: true});
}

function displayConceptCard(state, action) {
  return tassign(state, {displayCard: true});
}

function closeConceptCard(state, action) {
  return tassign(state, {displayCard: false});
}

function clearConceptCardState(state, action) {
  return tassign(state, {
     cardPopulating: false,
     cardPopulated: false,
     mvpAdding: false,
     mvpRemoving: false,
   });
}

function disableConceptCardView(state, action) {
  return tassign(state, {canViewConceptCard: false});
}

function enableConceptCardView(state, action) {
  return tassign(state, {canViewConceptCard: true});
}

function updateMvp(state, action) {
  return tassign(state, action);
}

function setAddingDefinitionMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: false, 
    isAddingDefinition: true,
    canAddAltDefinition: false,
    canAddSynonym: false,
    canAddSuperClass: false,
    canAddSubClass: false,
    canAddInterOntology: false,
    canAddProperty: false,
    canAddRelationship: false,
    canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false}});
}
function setAddingAltDefinitionMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddAltDefinition: false, 
    isAddingAltDefinition: true,
    canAddDefinition: false,
    canAddSynonym: false,
    canAddSuperClass: false,
    canAddSubClass: false,
    canAddInterOntology: false,
    canAddProperty: false,
    canAddRelationship: false,
    canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false}});
}
function setAddingSynonymMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddSynonym: false, 
    isAddingSynonym: true,
    canAddDefinition: false,
    canAddAltDefinition: false,
    canAddSuperClass: false,
    canAddSubClass:false,
    canAddInterOntology: false,
    canAddProperty: false,
    canAddRelationship: false,
    canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false}});
}
function resetAddMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: true, 
    isAddingDefinition: false,
    canAddAltDefinition: true, 
    isAddingAltDefinition: false,
    canAddSynonym: true, 
    isAddingSynonym: false,
    canAddSuperClass: true,
    isAddingSuperClass: false,
    canAddSubClass: true,
    isAddingSubClass: false,
    canAddInterOntology: true,
    isAddingInterOntology: false,
    canAddProperty: true,
    isAddingProperty: false,
    canAddRelationship: true,
    isAddingRelationship: false,
    canAddMappingDataElement: true,
    isAddingMappingDataElement: false,
    canAddMappingAlgorithm: true,
    isAddingMappingAlgorithm: false,
    canAddMappingValidation: true,
    isAddingMappingValidation: false}});
}

function updateConceptCardTabSelection(state, action) {
  return tassign(state, {
    conceptCardState: {
      selectedTab: action.payload
    }
  });
}

function setCardData(state, action) {
  return tassign(state, {
    conceptCardData: action.payload
  });
}

function displayConceptCardDetail(state, action) {
  return tassign(state, {
    mvpRemoving: false,
    mvpAdding: false,
    cardPopulating: false});
}
function setAddingSuperClassMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: false,
    canAddAltDefinition: false, 
    canAddSynonym: false,
    canAddSuperClass: false,
    isAddingSuperClass: true,
    canAddSubClass: false,
    canAddInterOntology: false,
    canAddProperty: false,
    canAddRelationship: false,
    canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false}});
}
function setAddingSubClassMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: false,
    canAddAltDefinition: false, 
    canAddSynonym: false,
    canAddSuperClass: false,
    canAddSubClass: false,
    isAddingSubClass: true,
    canAddInterOntology: false,
    canAddProperty: false,
    canAddRelationship: false,
    canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false}});
}
function setAddingInterOntologyMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: false,
    canAddAltDefinition: false, 
    canAddSynonym: false,
    canAddSuperClass: false,
    canAddSubClass: false,
    canAddInterOntology: false,
    isAddingInterOntology: true,
    canAddProperty: false,
    canAddRelationship: false,
   canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false}});

}
function setAddingPropertyMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: false,
    canAddAltDefinition: false, 
    canAddSynonym: false,
    canAddSuperClass: false,
    canAddSubClass: false,
    canAddInterOntology: false,
    canAddProperty: false,
    isAddingProperty: true,
    canAddRelationship: false,
    canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false}});

}
function setAddingRelationshipMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: false,
    canAddAltDefinition: false, 
    canAddSynonym: false,
    canAddSuperClass: false,
    canAddSubClass: false,
    canAddInterOntology: false,
    canAddProperty: false,
    canAddRelationship: false,
    isAddingRelationship: true,
    canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false}});
}
function setAddingMappingDataElementMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: false,
    canAddAltDefinition:false, 
    canAddSynonym: false,
    canAddSuperClass: false,
    canAddSubClass: false,
    canAddInterOntology: false,
    canAddProperty: false,
    canAddRelationship: false,
    canAddMappingDataElement: false,
    isAddingMappingDataElement: true,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false}});
}
function setAddingMappingAlgorithmMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: false,
    canAddAltDefinition: false, 
    canAddSynonym: false,
    canAddSuperClass: false,
    canAddSubClass: false,
    canAddInterOntology: false,
    canAddProperty: false,
    canAddRelationship: false,
    canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    isAddingMappingAlgorithm: true,
    canAddMappingValidation: false}});
}
function setAddingMappingValidationMvpState(state, action) {
  return tassign(state, {mvpAddState: {
    canAddDefinition: false,
    canAddAltDefinition: false, 
    canAddSynonym: false,
    canAddSuperClass: false,
    canAddSubClass: false,
    canAddInterOntology: false,
    canAddProperty: false,
    canAddRelationship: false,
    canAddMappingDataElement: false,
    canAddMappingAlgorithm: false,
    canAddMappingValidation: false,
    isAddingMappingValidation: true}});
}

function updateConceptCardTabFocus(state, action) {
  return tassign(state, {
    conceptCardState: {
      selectedTab: action.payload
    }
  });
}

function buildTabData(state, action) {
  return tassign(state, {
    templateTabData: action.payload
  });
}

function updateConceptCardBookmarkMessage(state, action) {
  return tassign(state, {bookmarkMessage: action.payload})
}

const INITIAL_STATE = {
  conceptCardData: {},
  concepCardState: {
    selectedTab: 'description'
  },
  conceptHistory: [],
  displayCard: false,
  cardPopulating: false,
  cardPopulated: false,
  canViewConceptCard: true,
  templateTabData: {},
  mvpAddState: {
    canAddDefinition: true,
    isAddingDefinition: false,
    canAddAltDefinition: true,
    isAddingAltDefinition: false,
    canAddSynonym: true,
    isAddingSynonym: false,

    canAddSubClass: true,
    isAddingSubClass: false,
    canAddSuperClass: true,
    isAddingSuperClass: false,

    canAddInterOntology: true,
    isAddingInterOntology: false,
    canAddProperty: true,
    isAddingProperty: false,
    canAddRelationship: true,
    isAddingRelationship: false,

    canAddMappingDataElement: true,
    isAddingMappingDataElement: false,
    canAddMappingAlgorithm: true,
    isAddingMappingAlgorithm: false,
    canAddMappingValidation: true,
    isAddingMappingValidation: false
  },
  mvpRemoving: false,
  mvpAdding: false,
  bookmarkMessage: '',
}

export default function conceptCardReducer(state=INITIAL_STATE, action) {
  switch (action.type) {
    case PREVIOUS_CONCEPT_HISTORY:
      return previousConceptHistory(state, action);
    case NEW_CONCEPT_HISTORY:
      return newConceptHistory(state, action);
    case CONCEPT_CARD_POPULATING:
      return conceptCardPopulating(state, action);
    case CONCEPT_CARD_MVP_DELETING:
      return conceptCardMvpDeleting(state, action);
    case CONCEPT_CARD_MVP_DELETED:
      return conceptCardMvpDeleted(state, action);
    case CONCEPT_CARD_POPULATED:
      return conceptCardPopulated(state, action);
    case DISPLAY_CONCEPT_CARD:
      return displayConceptCard(state, action);
    case CLOSE_CONCEPT_CARD:
      return closeConceptCard(state, action);
    case CLEAR_CONCEPT_CARD_STATE:
      return clearConceptCardState(state, action);
    case DISABLE_CONCEPT_CARD_VIEW:
      return disableConceptCardView(state, action);
    case ENABLE_CONCEPT_CARD_VIEW:
      return enableConceptCardView(state, action);
    case UPDATE_CONCEPT_CARD_TAB_SELECTION:
      return updateConceptCardTabSelection(state, action);
    case SET_CARD_DATA:
      return setCardData(state, action);
    case SET_ADDING_DEFINITION_MVP_STATE:
      return setAddingDefinitionMvpState(state, action);
    case RESET_ADD_MVP_STATE:
      return resetAddMvpState(state, action);
    case SET_ADDING_ALT_DEFINITION_MVP_STATE:
      return setAddingAltDefinitionMvpState(state, action);
    case SET_ADDING_SYNONYM_MVP_STATE:
      return setAddingSynonymMvpState(state, action);
    case CONCEPT_CARD_MVP_ADDING:
      return conceptCardMvpAdding(state, action);
    case CONCEPT_CARD_MVP_ADDED:
      return conceptCardMvpAdded(state, action);
    case DISPLAY_CONCEPT_CARD_DETAIL:
      return displayConceptCardDetail(state, action);
    case SET_ADDING_SUPER_CLASS_MVP_STATE:
      return setAddingSuperClassMvpState(state, action);
    case SET_ADDING_SUB_CLASS_MVP_STATE:
      return setAddingSubClassMvpState(state, action);
    case SET_ADDING_INTER_ONTOLOGY_MVP_STATE:
      return setAddingInterOntologyMvpState(state, action);
    case SET_ADDING_PROPERTY_MVP_STATE:
      return setAddingPropertyMvpState(state, action);
    case SET_ADDING_RELATIONSHIP_MVP_STATE:
      return setAddingRelationshipMvpState(state, action);
    case SET_ADDING_MAPPING_DATA_ELEMENT_MVP_STATE:
      return setAddingMappingDataElementMvpState(state, action);
    case SET_ADDING_MAPPING_ALGORITHM_MVP_STATE:
      return setAddingMappingAlgorithmMvpState(state, action);
    case SET_ADDING_MAPPING_VALIDATION_MVP_STATE:
      return setAddingMappingValidationMvpState(state, action);
    case UPDATE_CONCEPT_CARD_TAB_FOCUS:
      return updateConceptCardTabFocus(state, action);
    case BUILD_TAB_DATA:
      return buildTabData(state, action);
    case UPDATE_CONCEPT_CARD_BOOKMARK_MESSAGE:
      return updateConceptCardBookmarkMessage(state, action);
  }
  return state;
}
